<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T18:03:26.110409189 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Neoverse-V3" />
    <supported-cpuid id="Neoverse-V3AE" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions per Cycle (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleNeoverseV3CPU_CYCLES &gt; 0), ($InstructionsPerCycleNeoverseV3INST_RETIRED / $InstructionsPerCycleNeoverseV3CPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Cycle Accounting (Neoverse-V3)">
        <series color="255,153,0" description="This metric is the percentage of cycles that were stalled due to resource constraints in the frontend unit of the processor" expression="if(($FrontendStalledCyclesNeoverseV3CPU_CYCLES &gt; 0), min(($FrontendStalledCyclesNeoverseV3STALL_FRONTEND / $FrontendStalledCyclesNeoverseV3CPU_CYCLES), 1), 0)" name="Frontend Stalled Cycles" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit of the processor" expression="if(($BackendStalledCyclesNeoverseV3CPU_CYCLES &gt; 0), min(($BackendStalledCyclesNeoverseV3STALL_BACKEND / $BackendStalledCyclesNeoverseV3CPU_CYCLES), 1), 0)" name="Backend Stalled Cycles" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Level 1 (Neoverse-V3)">
        <series color="255,153,0" description="This metric is the percentage of total slots that were stalled due to resource constraints in the frontend of the processor" expression="if(($FrontendBoundNeoverseV3CPU_CYCLES &gt; 0), min((($FrontendBoundNeoverseV3STALL_SLOT_FRONTEND / (10 * $FrontendBoundNeoverseV3CPU_CYCLES)) - ($FrontendBoundNeoverseV3STALL_FRONTEND_FLUSH / $FrontendBoundNeoverseV3CPU_CYCLES)), 1), 0)" name="Frontend Bound" units="percent"/>
        <series color="255,0,229" description="This metric is the percentage of total slots that were stalled due to resource constraints in the backend of the processor" expression="if(($BackendBoundNeoverseV3CPU_CYCLES &gt; 0), min(($BackendBoundNeoverseV3STALL_SLOT_BACKEND / (10 * $BackendBoundNeoverseV3CPU_CYCLES)), 1), 0)" name="Backend Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total slots that retired operations, which indicates cycles that were utilized efficiently" expression="if(($RetiringNeoverseV3CPU_CYCLES &gt; 0) &amp;&amp; ($RetiringNeoverseV3OP_SPEC &gt; 0), min(((1 - ($RetiringNeoverseV3STALL_SLOT / ($RetiringNeoverseV3CPU_CYCLES * 10))) * ($RetiringNeoverseV3OP_RETIRED / $RetiringNeoverseV3OP_SPEC)), 1), 0)" name="Retiring" units="percent"/>
        <series color="0,255,25" description="This metric is the percentage of total slots that executed operations and didn't retire due to a pipeline flush This indicates cycles that were utilized but inefficiently" expression="if(($BadSpeculationNeoverseV3CPU_CYCLES &gt; 0) &amp;&amp; ($BadSpeculationNeoverseV3OP_SPEC &gt; 0), min((((1 - ($BadSpeculationNeoverseV3STALL_SLOT / (10 * $BadSpeculationNeoverseV3CPU_CYCLES))) * (1 - ($BadSpeculationNeoverseV3OP_RETIRED / $BadSpeculationNeoverseV3OP_SPEC))) + ($BadSpeculationNeoverseV3STALL_FRONTEND_FLUSH / $BadSpeculationNeoverseV3CPU_CYCLES)), 1), 0)" name="Bad Speculation" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="General (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures the percentage of operations speculatively executed that are subsequently retired" expression="if(($RetiredOperationsPercentageNeoverseV3OP_SPEC &gt; 0), min(($RetiredOperationsPercentageNeoverseV3OP_RETIRED / $RetiredOperationsPercentageNeoverseV3OP_SPEC), 1), 0)" name="Retired Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend due to frontend core resource constraints not related to instruction fetch latency issues caused by memory access components" expression="if(($FrontendCoreBoundNeoverseV3STALL_FRONTEND &gt; 0), min(($FrontendCoreBoundNeoverseV3STALL_FRONTEND_CPUBOUND / $FrontendCoreBoundNeoverseV3STALL_FRONTEND), 1), 0)" name="Frontend Core Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the frontend due to frontend core resource constraints related to the instruction fetch latency issues caused by memory access components" expression="if(($FrontendMemoryBoundNeoverseV3STALL_FRONTEND &gt; 0), min(($FrontendMemoryBoundNeoverseV3STALL_FRONTEND_MEMBOUND / $FrontendMemoryBoundNeoverseV3STALL_FRONTEND), 1), 0)" name="Frontend Memory Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Core Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend as the processor is recovering from a pipeline flush caused by bad speculation or other machine resteers" expression="if(($FrontendCoreFlushBoundNeoverseV3STALL_FRONTEND_CPUBOUND &gt; 0), min(($FrontendCoreFlushBoundNeoverseV3STALL_FRONTEND_FLUSH / $FrontendCoreFlushBoundNeoverseV3STALL_FRONTEND_CPUBOUND), 1), 0)" name="Frontend Core Flush Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the frontend as the decode unit is awaiting input from the branch prediction unit" expression="if(($FrontendCoreFlowBoundNeoverseV3STALL_FRONTEND_CPUBOUND &gt; 0), min(($FrontendCoreFlowBoundNeoverseV3STALL_FRONTEND_FLOW / $FrontendCoreFlowBoundNeoverseV3STALL_FRONTEND_CPUBOUND), 1), 0)" name="Frontend Core Flow Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Memory Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend due to instruction fetch latency issues caused by instruction cache misses" expression="if(($FrontendMemCacheBoundNeoverseV3STALL_FRONTEND_MEMBOUND &gt; 0), min((($FrontendMemCacheBoundNeoverseV3STALL_FRONTEND_L1I + $FrontendMemCacheBoundNeoverseV3STALL_FRONTEND_MEM) / $FrontendMemCacheBoundNeoverseV3STALL_FRONTEND_MEMBOUND), 1), 0)" name="Frontend Mem Cache Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the frontend due to instruction fetch latency issues caused by instruction TLB misses" expression="if(($FrontendMemTLBBoundNeoverseV3STALL_FRONTEND_MEMBOUND &gt; 0), min(($FrontendMemTLBBoundNeoverseV3STALL_FRONTEND_TLB / $FrontendMemTLBBoundNeoverseV3STALL_FRONTEND_MEMBOUND), 1), 0)" name="Frontend Mem TLB Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Mem Cache Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend due to memory access latency issues caused by level 1 instruction cache misses" expression="if((($FrontendCacheL1IBoundNeoverseV3STALL_FRONTEND_L1I + $FrontendCacheL1IBoundNeoverseV3STALL_FRONTEND_MEM) &gt; 0), min(($FrontendCacheL1IBoundNeoverseV3STALL_FRONTEND_L1I / ($FrontendCacheL1IBoundNeoverseV3STALL_FRONTEND_L1I + $FrontendCacheL1IBoundNeoverseV3STALL_FRONTEND_MEM)), 1), 0)" name="Frontend Cache L1I Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the frontend due to memory access latency issues caused by level 2 instruction cache misses" expression="if((($FrontendCacheL2IBoundNeoverseV3STALL_FRONTEND_L1I + $FrontendCacheL2IBoundNeoverseV3STALL_FRONTEND_MEM) &gt; 0), min(($FrontendCacheL2IBoundNeoverseV3STALL_FRONTEND_MEM / ($FrontendCacheL2IBoundNeoverseV3STALL_FRONTEND_L1I + $FrontendCacheL2IBoundNeoverseV3STALL_FRONTEND_MEM)), 1), 0)" name="Frontend Cache L2I Bound" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction Cache Effectiveness (Frontend Cache L1I Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKINeoverseV3INST_RETIRED &gt; 0), (($L1ICacheMPKINeoverseV3L1I_CACHE_REFILL / $L1ICacheMPKINeoverseV3INST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Instruction Cache Effectiveness (Frontend Cache L1I Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageNeoverseV3L1I_CACHE &gt; 0), min(($L1ICacheMissPercentageNeoverseV3L1I_CACHE_REFILL / $L1ICacheMissPercentageNeoverseV3L1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures the number of instruction TLB Walks per thousand instructions executed" expression="if(($ITLBMPKINeoverseV3INST_RETIRED &gt; 0), (($ITLBMPKINeoverseV3ITLB_WALK / $ITLBMPKINeoverseV3INST_RETIRED) * 1000), 0)" name="ITLB MPKI" units="misses"/>
        <series color="0,102,255" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKINeoverseV3INST_RETIRED &gt; 0), (($L1InstructionTLBMPKINeoverseV3L1I_TLB_REFILL / $L1InstructionTLBMPKINeoverseV3INST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures the ratio of instruction TLB Walks to the total number of instruction TLB accesses. This gives an indication of the effectiveness of the instruction TLB accesses." expression="if(($ITLBWalkPercentageNeoverseV3L1I_TLB &gt; 0), min(($ITLBWalkPercentageNeoverseV3ITLB_WALK / $ITLBWalkPercentageNeoverseV3L1I_TLB), 1), 0)" name="ITLB Walk Percentage" units="percent"/>
        <series color="255,0,229" description="This metric measures the ratio of instruction TLB Walks that returned large page to the total number of instruction TLB accesses" expression="if(($ITLBWalkLargePagePercentageNeoverseV3L1I_TLB &gt; 0), min(($ITLBWalkLargePagePercentageNeoverseV3ITLB_WALK_LARGE / $ITLBWalkLargePagePercentageNeoverseV3L1I_TLB), 1), 0)" name="ITLB Walk Large Page Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of instruction TLB Walks that returned large page to the total number of instruction TLB accesses" expression="if(($ITLBWalkSmallPagePercentageNeoverseV3L1I_TLB &gt; 0), min(($ITLBWalkSmallPagePercentageNeoverseV3ITLB_WALK_SMALL / $ITLBWalkSmallPagePercentageNeoverseV3L1I_TLB), 1), 0)" name="ITLB Walk Small Page Percentage" units="percent"/>
        <series color="0,255,25" description="This metric measures the ratio of level 1 instruction TLB accesses missed to the total number of level 1 instruction TLB accesses. This gives an indication of the effectiveness of the level 1 instruction TLB." expression="if(($L1InstructionTLBMissPercentageNeoverseV3L1I_TLB &gt; 0), min(($L1InstructionTLBMissPercentageNeoverseV3L1I_TLB_REFILL / $L1InstructionTLBMissPercentageNeoverseV3L1I_TLB), 1), 0)" name="L1 Instruction TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures the average depth of the instruction TLB walks for an instruction TLB refill" expression="if(($ITLBWalkAverageDepthOfAccessesNeoverseV3ITLB_WALK &gt; 0), ($ITLBWalkAverageDepthOfAccessesNeoverseV3ITLB_STEP / $ITLBWalkAverageDepthOfAccessesNeoverseV3ITLB_WALK), 0)" name="ITLB Walk Average Depth of Accesses" units="accesses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures the average latency of instruction TLB walks in CPU cycles" expression="if(($ITLBWalkAverageLatencyNeoverseV3ITLB_WALK &gt; 0), ($ITLBWalkAverageLatencyNeoverseV3ITLB_WALK_PERCYC / $ITLBWalkAverageLatencyNeoverseV3ITLB_WALK), 0)" name="ITLB Walk Average Latency" units="cycles"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to backend core resource constraints not related to instruction fetch latency issues caused by memory access components" expression="if(($BackendCoreBoundNeoverseV3STALL_BACKEND &gt; 0), min(($BackendCoreBoundNeoverseV3STALL_BACKEND_CPUBOUND / $BackendCoreBoundNeoverseV3STALL_BACKEND), 1), 0)" name="Backend Core Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the backend due to backend core resource constraints related to memory access latency issues caused by memory access components" expression="if(($BackendMemoryBoundNeoverseV3STALL_BACKEND &gt; 0), min(($BackendMemoryBoundNeoverseV3STALL_BACKEND_MEMBOUND / $BackendMemoryBoundNeoverseV3STALL_BACKEND), 1), 0)" name="Backend Memory Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Core Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend as the rename unit registers are unavailable" expression="if(($BackendCoreRenameBoundNeoverseV3STALL_BACKEND_CPUBOUND &gt; 0), min(($BackendCoreRenameBoundNeoverseV3STALL_BACKEND_RENAME / $BackendCoreRenameBoundNeoverseV3STALL_BACKEND_CPUBOUND), 1), 0)" name="Backend Core Rename Bound" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Register Rename Effectiveness (Backend Core Rename Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures the percentage of rename stall cycles due to vector register rename availability" expression="if(($VectorRegisterRenamePercentageNeoverseV3STALL_BACKEND_RENAME &gt; 0), min(($VectorRegisterRenamePercentageNeoverseV3IMP_STALL_BACKEND_RENAME_VRF / $VectorRegisterRenamePercentageNeoverseV3STALL_BACKEND_RENAME), 1), 0)" name="Vector Register Rename Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures the percentage of rename stall cycles due to flag register rename availability" expression="if(($FlagRegisterRenamePercentageNeoverseV3STALL_BACKEND_RENAME &gt; 0), min(($FlagRegisterRenamePercentageNeoverseV3IMP_STALL_BACKEND_RENAME_FRF / $FlagRegisterRenamePercentageNeoverseV3STALL_BACKEND_RENAME), 1), 0)" name="Flag Register Rename Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures the percentage of rename stall cycles due to GPR register rename availability" expression="if(($IntegerRegisterRenamePercentageNeoverseV3STALL_BACKEND_RENAME &gt; 0), min(($IntegerRegisterRenamePercentageNeoverseV3IMP_STALL_BACKEND_RENAME_GRF / $IntegerRegisterRenamePercentageNeoverseV3STALL_BACKEND_RENAME), 1), 0)" name="Integer Register Rename Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Core Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to issue queues being full to accept operations for execution" expression="if(($BackendBusyBoundNeoverseV3STALL_BACKEND &gt; 0), min(($BackendBusyBoundNeoverseV3STALL_BACKEND_BUSY / $BackendBusyBoundNeoverseV3STALL_BACKEND), 1), 0)" name="Backend Busy Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Memory Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to memory latency issues caused by data cache misses" expression="if(($BackendMemoryCacheBoundNeoverseV3STALL_BACKEND_MEMBOUND &gt; 0), min((($BackendMemoryCacheBoundNeoverseV3STALL_BACKEND_L1D + $BackendMemoryCacheBoundNeoverseV3STALL_BACKEND_MEM) / $BackendMemoryCacheBoundNeoverseV3STALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Memory Cache Bound" units="percent"/>
        <series color="153,0,255" description="This metric is the percentage of total cycles stalled in the backend due to memory access latency issues caused by data TLB misses" expression="if(($BackendMemoryTLBBoundNeoverseV3STALL_BACKEND_MEMBOUND &gt; 0), min(($BackendMemoryTLBBoundNeoverseV3STALL_BACKEND_TLB / $BackendMemoryTLBBoundNeoverseV3STALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Memory TLB Bound" units="percent"/>
        <series color="0,255,153" description="This metric is the percentage of total cycles stalled in the frontend due to memory write pending caused by stores stalled in the pre-commit stage" expression="if(($BackendMemoryStoreBoundNeoverseV3STALL_BACKEND_MEMBOUND &gt; 0), min(($BackendMemoryStoreBoundNeoverseV3STALL_BACKEND_ST / $BackendMemoryStoreBoundNeoverseV3STALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Memory Store Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Memory Cache Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to memory access latency issues caused by level 1 data cache misses" expression="if((($BackendCacheL1DBoundNeoverseV3STALL_BACKEND_L1D + $BackendCacheL1DBoundNeoverseV3STALL_BACKEND_MEM) &gt; 0), min(($BackendCacheL1DBoundNeoverseV3STALL_BACKEND_L1D / ($BackendCacheL1DBoundNeoverseV3STALL_BACKEND_L1D + $BackendCacheL1DBoundNeoverseV3STALL_BACKEND_MEM)), 1), 0)" name="Backend Cache L1D Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the backend due to memory access latency issues caused by level 2 data cache misses" expression="if((($BackendCacheL2DBoundNeoverseV3STALL_BACKEND_L1D + $BackendCacheL2DBoundNeoverseV3STALL_BACKEND_MEM) &gt; 0), min(($BackendCacheL2DBoundNeoverseV3STALL_BACKEND_MEM / ($BackendCacheL2DBoundNeoverseV3STALL_BACKEND_L1D + $BackendCacheL2DBoundNeoverseV3STALL_BACKEND_MEM)), 1), 0)" name="Backend Cache L2D Bound" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data Cache Effectiveness (Backend Cache L1D Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKINeoverseV3INST_RETIRED &gt; 0), (($L1DCacheMPKINeoverseV3L1D_CACHE_REFILL / $L1DCacheMPKINeoverseV3INST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
        <series color="0,102,255" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheDemandMPKINeoverseV3INST_RETIRED &gt; 0), ((($L1DCacheDemandMPKINeoverseV3L1D_CACHE_REFILL_RD + $L1DCacheDemandMPKINeoverseV3L1D_CACHE_REFILL_WR) / $L1DCacheDemandMPKINeoverseV3INST_RETIRED) * 1000), 0)" name="L1D Cache Demand MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Data Cache Effectiveness (Backend Cache L1D Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageNeoverseV3L1D_CACHE &gt; 0), min(($L1DCacheMissPercentageNeoverseV3L1D_CACHE_REFILL / $L1DCacheMissPercentageNeoverseV3L1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Unified Cache Effectiveness (Backend Cache L2D Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures the number of level 2 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMPKINeoverseV3INST_RETIRED &gt; 0), (($L2CacheMPKINeoverseV3L2D_CACHE_REFILL / $L2CacheMPKINeoverseV3INST_RETIRED) * 1000), 0)" name="L2 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Unified Cache Effectiveness (Backend Cache L2D Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures the ratio of level 2 cache accesses missed to the total number of level 2 cache accesses. This gives an indication of the effectiveness of the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMissPercentageNeoverseV3L2D_CACHE &gt; 0), min(($L2CacheMissPercentageNeoverseV3L2D_CACHE_REFILL / $L2CacheMissPercentageNeoverseV3L2D_CACHE), 1), 0)" name="L2 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Last Level Cache Effectiveness (Backend Cache L2D Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures the number of last level cache read accesses missed per thousand instructions executed" expression="if(($LLCacheReadMPKINeoverseV3INST_RETIRED &gt; 0), (($LLCacheReadMPKINeoverseV3LL_CACHE_MISS_RD / $LLCacheReadMPKINeoverseV3INST_RETIRED) * 1000), 0)" name="LL Cache Read MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Last Level Cache Effectiveness (Backend Cache L2D Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures the ratio of last level cache read accesses missed to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadMissPercentageNeoverseV3LL_CACHE_RD &gt; 0), min(($LLCacheReadMissPercentageNeoverseV3LL_CACHE_MISS_RD / $LLCacheReadMissPercentageNeoverseV3LL_CACHE_RD), 1), 0)" name="LL Cache Read Miss Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of last level cache read accesses hit in the cache to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadHitPercentageNeoverseV3LL_CACHE_RD &gt; 0), min((($LLCacheReadHitPercentageNeoverseV3LL_CACHE_RD - $LLCacheReadHitPercentageNeoverseV3LL_CACHE_MISS_RD) / $LLCacheReadHitPercentageNeoverseV3LL_CACHE_RD), 1), 0)" name="LL Cache Read Hit Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Memory TLB Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures the number of data TLB Walks per thousand instructions executed" expression="if(($DTLBMPKINeoverseV3INST_RETIRED &gt; 0), (($DTLBMPKINeoverseV3DTLB_WALK / $DTLBMPKINeoverseV3INST_RETIRED) * 1000), 0)" name="DTLB MPKI" units="misses"/>
        <series color="153,0,255" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKINeoverseV3INST_RETIRED &gt; 0), (($L1DataTLBMPKINeoverseV3L1D_TLB_REFILL / $L1DataTLBMPKINeoverseV3INST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
        <series color="0,255,153" description="This metric measures the number of level 2 unified TLB accesses missed per thousand instructions executed" expression="if(($L2UnifiedTLBMPKINeoverseV3INST_RETIRED &gt; 0), (($L2UnifiedTLBMPKINeoverseV3L2D_TLB_REFILL / $L2UnifiedTLBMPKINeoverseV3INST_RETIRED) * 1000), 0)" name="L2 Unified TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Data TLB Effectiveness (Backend Memory TLB Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures the ratio of data TLB Walks to the total number of data TLB accesses. This gives an indication of the effectiveness of the data TLB accesses." expression="if(($DTLBWalkPercentageNeoverseV3L1D_TLB &gt; 0), min(($DTLBWalkPercentageNeoverseV3DTLB_WALK / $DTLBWalkPercentageNeoverseV3L1D_TLB), 1), 0)" name="DTLB Walk Percentage" units="percent"/>
        <series color="255,0,153" description="This metric measures the ratio of data TLB Walks that returned large page to the total number of data TLB accesses" expression="if(($DTLBWalkLargePagePercentageNeoverseV3L1D_TLB &gt; 0), min(($DTLBWalkLargePagePercentageNeoverseV3DTLB_WALK_LARGE / $DTLBWalkLargePagePercentageNeoverseV3L1D_TLB), 1), 0)" name="DTLB Walk Large Page Percentage" units="percent"/>
        <series color="51,0,255" description="This metric measures the ratio of data TLB Walks that returned large page to the total number of data TLB accesses" expression="if(($DTLBWalkSmallPagePercentageNeoverseV3L1D_TLB &gt; 0), min(($DTLBWalkSmallPagePercentageNeoverseV3DTLB_WALK_SMALL / $DTLBWalkSmallPagePercentageNeoverseV3L1D_TLB), 1), 0)" name="DTLB Walk Small Page Percentage" units="percent"/>
        <series color="0,255,255" description="This metric measures the ratio of level 1 data TLB accesses missed to the total number of level 1 data TLB accesses. This gives an indication of the effectiveness of the level 1 data TLB." expression="if(($L1DataTLBMissPercentageNeoverseV3L1D_TLB &gt; 0), min(($L1DataTLBMissPercentageNeoverseV3L1D_TLB_REFILL / $L1DataTLBMissPercentageNeoverseV3L1D_TLB), 1), 0)" name="L1 Data TLB Miss Percentage" units="percent"/>
        <series color="51,255,0" description="This metric measures the ratio of level 2 unified TLB accesses missed to the total number of level 2 unified TLB accesses. This gives an indication of the effectiveness of the level 2 TLB." expression="if(($L2UnifiedTLBMissPercentageNeoverseV3L2D_TLB &gt; 0), min(($L2UnifiedTLBMissPercentageNeoverseV3L2D_TLB_REFILL / $L2UnifiedTLBMissPercentageNeoverseV3L2D_TLB), 1), 0)" name="L2 Unified TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Memory TLB Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures the average depth of the data TLB walks for a data TLB refill" expression="if(($DTLBWalkAverageDepthOfAccessesNeoverseV3DTLB_WALK &gt; 0), ($DTLBWalkAverageDepthOfAccessesNeoverseV3DTLB_STEP / $DTLBWalkAverageDepthOfAccessesNeoverseV3DTLB_WALK), 0)" name="DTLB Walk Average Depth of Accesses" units="accesses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Memory TLB Bound) (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures the average latency of data TLB walks in CPU cycles" expression="if(($DTLBWalkAverageLatencyNeoverseV3DTLB_WALK &gt; 0), ($DTLBWalkAverageLatencyNeoverseV3DTLB_WALK_PERCYC / $DTLBWalkAverageLatencyNeoverseV3DTLB_WALK), 0)" name="DTLB Walk Average Latency" units="cycles"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures instruction and data barrier operations as a percentage of operations speculatively executed" expression="if(($BarrierOperationsPercentageNeoverseV3INST_SPEC &gt; 0), min(((($BarrierOperationsPercentageNeoverseV3ISB_SPEC + $BarrierOperationsPercentageNeoverseV3DSB_SPEC) + $BarrierOperationsPercentageNeoverseV3DMB_SPEC) / $BarrierOperationsPercentageNeoverseV3INST_SPEC), 1), 0)" name="Barrier Operations Percentage" units="percent"/>
        <series color="255,0,102" description="This metric measures branch operations as a percentage of operations speculatively executed" expression="if(($BranchOperationsPercentageNeoverseV3INST_SPEC &gt; 0), min((($BranchOperationsPercentageNeoverseV3BR_IMMED_SPEC + $BranchOperationsPercentageNeoverseV3BR_INDIRECT_SPEC) / $BranchOperationsPercentageNeoverseV3INST_SPEC), 1), 0)" name="Branch Operations Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageNeoverseV3INST_SPEC &gt; 0), min(($CryptoOperationsPercentageNeoverseV3CRYPTO_SPEC / $CryptoOperationsPercentageNeoverseV3INST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures scalar integer operations as a percentage of operations speculatively executed" expression="if(($IntegerOperationsPercentageNeoverseV3INST_SPEC &gt; 0), min(($IntegerOperationsPercentageNeoverseV3DP_SPEC / $IntegerOperationsPercentageNeoverseV3INST_SPEC), 1), 0)" name="Integer Operations Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures load and store operations as a percentage of operations speculatively executed" expression="if(($LoadStoreOperationsPercentageNeoverseV3INST_SPEC &gt; 0), min(($LoadStoreOperationsPercentageNeoverseV3LDST_SPEC / $LoadStoreOperationsPercentageNeoverseV3INST_SPEC), 1), 0)" name="Load/Store Operations Percentage" units="percent"/>
        <series color="102,255,0" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageNeoverseV3INST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageNeoverseV3VFP_SPEC / $FloatingPointOperationsPercentageNeoverseV3INST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
        <series color="128,77,0" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageNeoverseV3INST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageNeoverseV3ASE_SPEC / $AdvancedSIMDOperationsPercentageNeoverseV3INST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
        <series color="128,0,51" description="This metric measures scalable vector operations, including loads and stores, as a percentage of operations speculatively executed" expression="if(($SVEOperationsLoadStoreInclusivePercentageNeoverseV3INST_SPEC &gt; 0), min(($SVEOperationsLoadStoreInclusivePercentageNeoverseV3SVE_INST_SPEC / $SVEOperationsLoadStoreInclusivePercentageNeoverseV3INST_SPEC), 1), 0)" name="SVE Operations (Load/Store Inclusive) Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures half-precision floating point operations as a percentage of operations speculatively executed" expression="if(($HalfPrecisionFloatingPointPercentageNeoverseV3INST_SPEC &gt; 0), min(($HalfPrecisionFloatingPointPercentageNeoverseV3FP_HP_SPEC / $HalfPrecisionFloatingPointPercentageNeoverseV3INST_SPEC), 1), 0)" name="Half Precision Floating Point Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures single-precision floating point operations as a percentage of operations speculatively executed" expression="if(($SinglePrecisionFloatingPointPercentageNeoverseV3INST_SPEC &gt; 0), min(($SinglePrecisionFloatingPointPercentageNeoverseV3FP_SP_SPEC / $SinglePrecisionFloatingPointPercentageNeoverseV3INST_SPEC), 1), 0)" name="Single Precision Floating Point Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures double-precision floating point operations as a percentage of operations speculatively executed" expression="if(($DoublePrecisionFloatingPointPercentageNeoverseV3INST_SPEC &gt; 0), min(($DoublePrecisionFloatingPointPercentageNeoverseV3FP_DP_SPEC / $DoublePrecisionFloatingPointPercentageNeoverseV3INST_SPEC), 1), 0)" name="Double Precision Floating Point Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures load-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($LoadExclusiveInstructionsPercentageNeoverseV3INST_SPEC &gt; 0), min(($LoadExclusiveInstructionsPercentageNeoverseV3LDREX_SPEC / $LoadExclusiveInstructionsPercentageNeoverseV3INST_SPEC), 1), 0)" name="Load-Exclusive Instructions Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($StoreExclusiveInstructionsPercentageNeoverseV3INST_SPEC &gt; 0), min(($StoreExclusiveInstructionsPercentageNeoverseV3STREX_SPEC / $StoreExclusiveInstructionsPercentageNeoverseV3INST_SPEC), 1), 0)" name="Store-Exclusive Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of load and store operations speculatively executed" expression="if(($LoadAsLoadStoreOperationsPercentageNeoverseV3LDST_SPEC &gt; 0), min(($LoadAsLoadStoreOperationsPercentageNeoverseV3LD_SPEC / $LoadAsLoadStoreOperationsPercentageNeoverseV3LDST_SPEC), 1), 0)" name="Load as Load/Store Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of load and store operations speculatively executed" expression="if(($StoreAsLoadStoreOperationsPercentageNeoverseV3LDST_SPEC &gt; 0), min(($StoreAsLoadStoreOperationsPercentageNeoverseV3ST_SPEC / $StoreAsLoadStoreOperationsPercentageNeoverseV3LDST_SPEC), 1), 0)" name="Store as Load/Store Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageNeoverseV3INST_SPEC &gt; 0), min(($LoadOperationsPercentageNeoverseV3LD_SPEC / $LoadOperationsPercentageNeoverseV3INST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageNeoverseV3INST_SPEC &gt; 0), min(($StoreOperationsPercentageNeoverseV3ST_SPEC / $StoreOperationsPercentageNeoverseV3INST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures memory-read instructions with acquire or acquirepc semantics as a percentage of instructions speculatively executed" expression="if(($LoadAcquireInstructionsPercentageNeoverseV3INST_SPEC &gt; 0), min(($LoadAcquireInstructionsPercentageNeoverseV3RC_LD_SPEC / $LoadAcquireInstructionsPercentageNeoverseV3INST_SPEC), 1), 0)" name="Load-Acquire Instructions Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures memory-write instructions with release semantics as a percentage of instructions speculatively executed" expression="if(($StoreReleaseInstructionsPercentageNeoverseV3INST_SPEC &gt; 0), min(($StoreReleaseInstructionsPercentageNeoverseV3RC_ST_SPEC / $StoreReleaseInstructionsPercentageNeoverseV3INST_SPEC), 1), 0)" name="Store-Release Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch Effectiveness (Bad Speculation) (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKINeoverseV3INST_RETIRED &gt; 0), (($BranchMPKINeoverseV3BR_MIS_PRED_RETIRED / $BranchMPKINeoverseV3INST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Effectiveness (Bad Speculation) (Neoverse-V3)">
        <series color="255,153,0" description="This metric measures the ratio of branches mispredicted to the total number of branches architecturally executed. This gives an indication of the effectiveness of the branch prediction unit." expression="if(($BranchMispredictionPercentageNeoverseV3BR_RETIRED &gt; 0), min(($BranchMispredictionPercentageNeoverseV3BR_MIS_PRED_RETIRED / $BranchMispredictionPercentageNeoverseV3BR_RETIRED), 1), 0)" name="Branch Misprediction Percentage" units="percent"/>
        <series color="255,0,229" description="This metric measures the ratio of direct branches retired to the total number of branches architecturally executed" expression="if(($BranchDirectPercentageNeoverseV3BR_RETIRED &gt; 0), min(($BranchDirectPercentageNeoverseV3BR_IMMED_RETIRED / $BranchDirectPercentageNeoverseV3BR_RETIRED), 1), 0)" name="Branch Direct Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of indirect branches retired, including function returns, to the total number of branches architecturally executed" expression="if(($BranchIndirectPercentageNeoverseV3BR_RETIRED &gt; 0), min(($BranchIndirectPercentageNeoverseV3BR_IND_RETIRED / $BranchIndirectPercentageNeoverseV3BR_RETIRED), 1), 0)" name="Branch Indirect Percentage" units="percent"/>
        <series color="0,255,25" description="This metric measures the ratio of branches retired that are function returns to the total number of branches architecturally executed" expression="if(($BranchReturnPercentageNeoverseV3BR_RETIRED &gt; 0), min(($BranchReturnPercentageNeoverseV3BR_RETURN_RETIRED / $BranchReturnPercentageNeoverseV3BR_RETIRED), 1), 0)" name="Branch Return Percentage" units="percent"/>
   </chart>
    <select-metric id="ARMv9_Neoverse_V3AE_metric_backend_bound" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_backend_busy_bound" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_backend_cache_l1d_bound" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_backend_cache_l2d_bound" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_backend_core_bound" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_backend_core_rename_bound" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_backend_mem_bound" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_backend_mem_cache_bound" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_backend_mem_store_bound" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_backend_mem_tlb_bound" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_backend_stalled_cycles" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_bad_speculation" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_barrier_percentage" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_branch_direct_ratio" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_branch_indirect_ratio" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_branch_mpki" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_branch_percentage" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_branch_return_ratio" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_crypto_percentage" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_dtlb_mpki" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_dtlb_walk_average_depth" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_dtlb_walk_average_latency" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_dtlb_walk_large_ratio" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_dtlb_walk_small_ratio" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_fp16_percentage" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_fp32_percentage" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_fp64_percentage" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_frontend_bound" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_frontend_cache_l1i_bound" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_frontend_cache_l2i_bound" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_frontend_core_bound" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_frontend_core_flow_bound" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_frontend_core_flush_bound" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_frontend_mem_bound" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_frontend_mem_cache_bound" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_frontend_mem_tlb_bound" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_integer_dp_percentage" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_ipc" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_itlb_mpki" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_itlb_walk_average_depth" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_itlb_walk_average_latency" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_itlb_walk_large_ratio" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_itlb_walk_ratio" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_itlb_walk_small_ratio" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_l1d_cache_demand_mpki" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_l1d_cache_mpki" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_l1i_cache_mpki" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_l2_cache_mpki" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_l2_tlb_mpki" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_ldrex_percentage" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_load_ls_percentage" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_load_percentage" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_load_store_percentage" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_rc_ld_percentage" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_rc_st_percentage" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_rename_stall_flags_ratio" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_rename_stall_int_ratio" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_rename_stall_vec_ratio" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_retired_ops_percent" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_retiring" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_scalar_fp_percentage" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_simd_percentage" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_store_ls_percentage" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_store_percentage" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_strex_percentage" />
    <select-metric id="ARMv9_Neoverse_V3AE_metric_sve_all_percentage" />
    <select-metric id="ARMv9_Neoverse_V3_metric_backend_bound" />
    <select-metric id="ARMv9_Neoverse_V3_metric_backend_busy_bound" />
    <select-metric id="ARMv9_Neoverse_V3_metric_backend_cache_l1d_bound" />
    <select-metric id="ARMv9_Neoverse_V3_metric_backend_cache_l2d_bound" />
    <select-metric id="ARMv9_Neoverse_V3_metric_backend_core_bound" />
    <select-metric id="ARMv9_Neoverse_V3_metric_backend_core_rename_bound" />
    <select-metric id="ARMv9_Neoverse_V3_metric_backend_mem_bound" />
    <select-metric id="ARMv9_Neoverse_V3_metric_backend_mem_cache_bound" />
    <select-metric id="ARMv9_Neoverse_V3_metric_backend_mem_store_bound" />
    <select-metric id="ARMv9_Neoverse_V3_metric_backend_mem_tlb_bound" />
    <select-metric id="ARMv9_Neoverse_V3_metric_backend_stalled_cycles" />
    <select-metric id="ARMv9_Neoverse_V3_metric_bad_speculation" />
    <select-metric id="ARMv9_Neoverse_V3_metric_barrier_percentage" />
    <select-metric id="ARMv9_Neoverse_V3_metric_branch_direct_ratio" />
    <select-metric id="ARMv9_Neoverse_V3_metric_branch_indirect_ratio" />
    <select-metric id="ARMv9_Neoverse_V3_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv9_Neoverse_V3_metric_branch_mpki" />
    <select-metric id="ARMv9_Neoverse_V3_metric_branch_percentage" />
    <select-metric id="ARMv9_Neoverse_V3_metric_branch_return_ratio" />
    <select-metric id="ARMv9_Neoverse_V3_metric_crypto_percentage" />
    <select-metric id="ARMv9_Neoverse_V3_metric_dtlb_mpki" />
    <select-metric id="ARMv9_Neoverse_V3_metric_dtlb_walk_average_depth" />
    <select-metric id="ARMv9_Neoverse_V3_metric_dtlb_walk_average_latency" />
    <select-metric id="ARMv9_Neoverse_V3_metric_dtlb_walk_large_ratio" />
    <select-metric id="ARMv9_Neoverse_V3_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv9_Neoverse_V3_metric_dtlb_walk_small_ratio" />
    <select-metric id="ARMv9_Neoverse_V3_metric_fp16_percentage" />
    <select-metric id="ARMv9_Neoverse_V3_metric_fp32_percentage" />
    <select-metric id="ARMv9_Neoverse_V3_metric_fp64_percentage" />
    <select-metric id="ARMv9_Neoverse_V3_metric_frontend_bound" />
    <select-metric id="ARMv9_Neoverse_V3_metric_frontend_cache_l1i_bound" />
    <select-metric id="ARMv9_Neoverse_V3_metric_frontend_cache_l2i_bound" />
    <select-metric id="ARMv9_Neoverse_V3_metric_frontend_core_bound" />
    <select-metric id="ARMv9_Neoverse_V3_metric_frontend_core_flow_bound" />
    <select-metric id="ARMv9_Neoverse_V3_metric_frontend_core_flush_bound" />
    <select-metric id="ARMv9_Neoverse_V3_metric_frontend_mem_bound" />
    <select-metric id="ARMv9_Neoverse_V3_metric_frontend_mem_cache_bound" />
    <select-metric id="ARMv9_Neoverse_V3_metric_frontend_mem_tlb_bound" />
    <select-metric id="ARMv9_Neoverse_V3_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv9_Neoverse_V3_metric_integer_dp_percentage" />
    <select-metric id="ARMv9_Neoverse_V3_metric_ipc" />
    <select-metric id="ARMv9_Neoverse_V3_metric_itlb_mpki" />
    <select-metric id="ARMv9_Neoverse_V3_metric_itlb_walk_average_depth" />
    <select-metric id="ARMv9_Neoverse_V3_metric_itlb_walk_average_latency" />
    <select-metric id="ARMv9_Neoverse_V3_metric_itlb_walk_large_ratio" />
    <select-metric id="ARMv9_Neoverse_V3_metric_itlb_walk_ratio" />
    <select-metric id="ARMv9_Neoverse_V3_metric_itlb_walk_small_ratio" />
    <select-metric id="ARMv9_Neoverse_V3_metric_l1d_cache_demand_mpki" />
    <select-metric id="ARMv9_Neoverse_V3_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_V3_metric_l1d_cache_mpki" />
    <select-metric id="ARMv9_Neoverse_V3_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_V3_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv9_Neoverse_V3_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_V3_metric_l1i_cache_mpki" />
    <select-metric id="ARMv9_Neoverse_V3_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_V3_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv9_Neoverse_V3_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_V3_metric_l2_cache_mpki" />
    <select-metric id="ARMv9_Neoverse_V3_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_V3_metric_l2_tlb_mpki" />
    <select-metric id="ARMv9_Neoverse_V3_metric_ldrex_percentage" />
    <select-metric id="ARMv9_Neoverse_V3_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv9_Neoverse_V3_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_V3_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv9_Neoverse_V3_metric_load_ls_percentage" />
    <select-metric id="ARMv9_Neoverse_V3_metric_load_percentage" />
    <select-metric id="ARMv9_Neoverse_V3_metric_load_store_percentage" />
    <select-metric id="ARMv9_Neoverse_V3_metric_rc_ld_percentage" />
    <select-metric id="ARMv9_Neoverse_V3_metric_rc_st_percentage" />
    <select-metric id="ARMv9_Neoverse_V3_metric_rename_stall_flags_ratio" />
    <select-metric id="ARMv9_Neoverse_V3_metric_rename_stall_int_ratio" />
    <select-metric id="ARMv9_Neoverse_V3_metric_rename_stall_vec_ratio" />
    <select-metric id="ARMv9_Neoverse_V3_metric_retired_ops_percent" />
    <select-metric id="ARMv9_Neoverse_V3_metric_retiring" />
    <select-metric id="ARMv9_Neoverse_V3_metric_scalar_fp_percentage" />
    <select-metric id="ARMv9_Neoverse_V3_metric_simd_percentage" />
    <select-metric id="ARMv9_Neoverse_V3_metric_store_ls_percentage" />
    <select-metric id="ARMv9_Neoverse_V3_metric_store_percentage" />
    <select-metric id="ARMv9_Neoverse_V3_metric_strex_percentage" />
    <select-metric id="ARMv9_Neoverse_V3_metric_sve_all_percentage" />
</template>
